/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/

#include "derivative.h"
#include "JM128_Bootloader.h"

extern unsigned long far __SP_AFTER_RESET[];
extern unsigned long far __SP_INIT[];
extern unsigned long far _SP_INIT, _SDA_BASE;
extern unsigned long far _START_BSS, _END_BSS;
extern unsigned long far _START_SBSS, _END_SBSS;
extern unsigned long far __DATA_RAM, __DATA_ROM, __DATA_END;



#define USR_ENTRY_ADDR   0x000011C0

void _Entry(void)
{
   byte i;
   
  PTGDD_PTGDD0 = 0;               // PTG0 is input
  PTGPE_PTGPE0 = 1;               // internal pullup for PTG0
  
  
  // delay some time for oscillator and GPIO stable
  for(i=0;i<3;i++) {
    
    __RESET_WATCHDOG();
  }
 
  
  if(PTGD_PTGD0) 
  {
     asm (JMP USR_ENTRY_ADDR);      // jump to user entry
       
  } 
  
  else 
  {
     __asm {

           move.w        #0x2700,sr
          lea __SP_AFTER_RESET,a7;
           lea           _SP_INIT,a7
           movea.l       #0,a6
           link          a6,#0
           lea           _SDA_BASE,a5
           lea           _END_BSS, a0
           lea           _START_BSS, a1
           suba.l        a1, a0
           move.l        a0, d0

           beq           __skip_bss__

           lea           _START_BSS, a0

           /* call clear_mem with base pointer in a0 and size in d0 */
           //jsr           clear_mem

        __skip_bss__:
        }
    
    SOPT1 = 0x00;                     // disable COP
    SOPT2 = 0x00;       
    
    MCGC2 = 0x36;
    while(!(MCGSC & 0x02)){};		      //wait for the OSC stable
    MCGC1 = 0x98;
    while((MCGSC & 0x1C )!= 0x08){}; // external clock is selected
	  MCGC3 = 0x48;
	  while ((MCGSC & 0x48) != 0x48){};	//wait for the PLL is locked
	  MCGC1 = 0x18;
    while((MCGSC & 0x6C) != 0x6C){};
    
    //USBTRC0 = 0x44;
    Bootloader_Main();
  }
}